/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.argumentloaded;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.plugin.management.PluginRequest;
import org.gradle.plugin.management.internal.PluginCoordinates;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

public final class ArgumentSourcedPluginRequest
implements PluginRequestInternal {
    private static final int PLUGIN_ID_INDEX = 0;
    private static final int PLUGIN_VERSION_INDEX = 1;
    private final PluginId id;
    private final String version;

    public static ArgumentSourcedPluginRequest parsePluginRequest(String pluginCoords) {
        String[] parts = pluginCoords.split(":");
        if (parts.length != 2 || Strings.isNullOrEmpty((String)parts[0]) || Strings.isNullOrEmpty((String)parts[1])) {
            throw new IllegalArgumentException(String.format("Invalid plugin format: '%s'. Expected format is 'id:version'.", pluginCoords));
        }
        return new ArgumentSourcedPluginRequest(parts[0], parts[1]);
    }

    public ArgumentSourcedPluginRequest(String pluginId, String pluginVersion) {
        this.id = DefaultPluginId.of(pluginId);
        this.version = pluginVersion;
    }

    @Override
    public boolean isApply() {
        return true;
    }

    @Override
    @Nullable
    public Integer getLineNumber() {
        return null;
    }

    @Override
    @Nullable
    public String getScriptDisplayName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return String.format("[id: '%s', version: '%s', apply: %s]", this.id, this.version, this.isApply());
    }

    @Override
    public PluginRequest getOriginalRequest() {
        return this;
    }

    @Override
    public PluginRequestInternal.Origin getOrigin() {
        return PluginRequestInternal.Origin.OTHER;
    }

    @Override
    public Optional<PluginCoordinates> getAlternativeCoordinates() {
        return Optional.empty();
    }

    public PluginId getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public ModuleVersionSelector getModule() {
        return null;
    }
}

